<!doctype html>
<html lang="en">

<head>

    <?= $title_meta ?>

    <?= $this->include('partials/head-css') ?>

</head>

<?= $this->include('partials/body') ?>

<!-- <body data-layout="horizontal"> -->

<!-- Begin page -->
<div id="layout-wrapper">

    <?= $this->include('partials/menu') ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <?= $page_title ?>
                <!-- end page title -->

                <div class="row">
                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Bootstrap Validation - Normal</h4>
                                <p class="card-title-desc">Provide valuable, actionable feedback to your users with HTML5 form validation–available in all our supported browsers.</p>
                            </div>
                            <div class="card-body">
                                <form class="needs-validation" novalidate>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label" for="validationCustom01">First name</label>
                                                <input type="text" class="form-control" id="validationCustom01" placeholder="First name" value="Mark" required>
                                                <div class="valid-feedback">
                                                    Looks good!
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label" for="validationCustom02">Last name</label>
                                                <input type="text" class="form-control" id="validationCustom02" placeholder="Last name" value="Otto" required>
                                                <div class="valid-feedback">
                                                    Looks good!
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label" for="validationCustom03">City</label>
                                                <input type="text" class="form-control" id="validationCustom03" placeholder="City" required>
                                                <div class="invalid-feedback">
                                                    Please provide a valid city.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label" for="validationCustom04">State</label>
                                                <input type="text" class="form-control" id="validationCustom04" placeholder="State" required>
                                                <div class="invalid-feedback">
                                                    Please provide a valid state.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label class="form-label" for="validationCustom05">Zip</label>
                                                <input type="text" class="form-control" id="validationCustom05" placeholder="Zip" required>
                                                <div class="invalid-feedback">
                                                    Please provide a valid zip.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" id="invalidCheck" required>
                                                    <label class="form-check-label" for="invalidCheck">Agree to terms and conditions</label>
                                                    <div class="invalid-feedback">
                                                        You must agree before submitting.
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-primary" type="submit">Submit form</button>
                                </form>
                            </div>
                        </div>
                        <!-- end card -->
                    </div> <!-- end col -->

                    <div class="col-xl-6">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Bootstrap Validation (Tooltips)</h4>
                                <p class="card-title-desc">If your form layout allows it, you can swap the <code>.{valid|invalid}-feedback</code> classes for <code>.{valid|invalid}-tooltip</code> classes to display validation feedback in a styled tooltip.</p>
                            </div>
                            <div class="card-body">

                                <form class="needs-validation" novalidate>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3 position-relative">
                                                <label class="form-label" for="validationTooltip01">First name</label>
                                                <input type="text" class="form-control" id="validationTooltip01" placeholder="First name" value="Mark" required>
                                                <div class="valid-tooltip">
                                                    Looks good!
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3 position-relative">
                                                <label class="form-label" for="validationTooltip02">Last name</label>
                                                <input type="text" class="form-control" id="validationTooltip02" placeholder="Last name" value="Otto" required>
                                                <div class="valid-tooltip">
                                                    Looks good!
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3 position-relative">
                                                <label class="form-label" for="validationTooltipUsername">Username</label>
                                                <div class="input-group">
                                                    <span class="input-group-text" id="validationTooltipUsernamePrepend">@</span>
                                                    <input type="text" class="form-control" id="validationTooltipUsername" placeholder="Username" aria-describedby="validationTooltipUsernamePrepend" required>
                                                    <div class="invalid-tooltip">
                                                        Please choose a unique and valid username.
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3 position-relative">
                                                <label class="form-label" for="validationTooltip03">City</label>
                                                <input type="text" class="form-control" id="validationTooltip03" placeholder="City" required>
                                                <div class="invalid-tooltip">
                                                    Please provide a valid city.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3 position-relative">
                                                <label class="form-label" for="validationTooltip04">State</label>
                                                <input type="text" class="form-control" id="validationTooltip04" placeholder="State" required>
                                                <div class="invalid-tooltip">
                                                    Please provide a valid state.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="btn btn-primary" type="submit">Submit form</button>
                                </form>
                            </div>
                        </div>
                        <!-- end card -->
                    </div> <!-- end col -->
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">PristineJS Validation</h4>
                                <p class="card-title-desc">PristineJS Vanilla javascript form validation library</p>
                            </div>
                            <!-- end card header -->

                            <div class="card-body">
                                <div>
                                    <h5 class="card-title mb-4">Validation Examples</h5>
                                    <form id="pristine-valid-example" novalidate method="post">
                                        <input type="hidden" />
                                        <div class="row">
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label>Username</label>
                                                    <input type="text" required data-pristine-required-message="Please Enter a username" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label>Email</label>
                                                    <input type="email" required data-pristine-required-message="Please Enter a Email" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label>Your age (required, min. 14)</label>
                                                    <input type="number" min="14" data-pristine-min-message="You must be at least 14-years-old" required class="form-control" value="10" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label>Password (required)</label>
                                                    <input type="password" id="pwd" required data-pristine-required-message="Please Enter a password" data-pristine-pattern="/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9]).{8,}$/" data-pristine-pattern-message="Minimum 8 characters, at least one uppercase letter, one lowercase letter and one number" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label>Retype password</label>
                                                    <input type="password" data-pristine-equals="#pwd" data-pristine-equals-message="Passwords don't match" class="form-control" />
                                                </div>
                                            </div>
                                        </div>
                                        <!-- end row -->

                                        <div class="form-group mb-3 form-check">
                                            <input id="term-check01" type="checkbox" class="form-check-input" name="future" required data-pristine-required-message="You must accept the terms and conditions" />
                                            <label class="form-check-label" for="term-check01">I accept the terms and conditions</label><br />
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary">Submit form</button>
                                        </div>
                                    </form>
                                </div>

                                <hr class="my-5">

                                <div>
                                    <h5 class="card-title mb-4">Common validations</h5>

                                    <form id="pristine-valid-common" novalidate method="post">
                                        <input type="hidden" />
                                        <div class="row">
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">Required</label>
                                                    <input type="text" required class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">minlength=5, but not required</label>
                                                    <input type="text" minlength="5" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">type=email, not required</label>
                                                    <input type="email" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">number, not required</label>
                                                    <input type="number" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">number, min=100, not required</label>
                                                    <input type="number" min="100" class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">Select</label>
                                                    <select required class="form-control form-select">
                                                        <option value="">-----</option>
                                                        <option value="wr">Writing</option>
                                                        <option value="ph">Photography</option>
                                                        <option value="cy">Cycling</option>
                                                    </select>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="form-group mb-3 inline-label">
                                            <label class="form-label">Hobbies (required, min=2)</label>
                                            <div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" id="hobbiecheck01" type="checkbox" min="2" name="hobbie" required data-pristine-min-message="Select at least 2" />
                                                    <label class="form-check-label" for="hobbiecheck01">Writing</label>
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" id="hobbiecheck02" type="checkbox" min="2" name="hobbie" required data-pristine-min-message="Select at least 2" />
                                                    <label class="form-check-label" for="hobbiecheck02">Photography</label><br />
                                                </div>
                                                <div class="form-check form-check-inline">
                                                    <input class="form-check-input" id="hobbiecheck03" type="checkbox" min="2" name="hobbie" required data-pristine-min-message="Select at least 2" />
                                                    <label class="form-check-label" for="hobbiecheck03">Cycling</label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">pattern=/^\d+\.\d{2}$/ (match decimal with 2 points), required</label>
                                                    <input type="number" pattern="/^\d+\.\d{2}$/g" required class="form-control" />
                                                </div>
                                            </div>
                                            <div class="col-xl-4 col-md-6">
                                                <div class="form-group mb-3">
                                                    <label class="form-label">above field with custom message</label>
                                                    <input type="number" pattern="/^\d+\.\d{2}$/g" required data-pristine-pattern-message="The value must have 2 decimal points" class="form-control" />
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <input type="submit" value="Submit" class="btn btn-primary" />
                                        </div>
                                    </form>
                                </div>

                                <hr class="my-5">

                                <div>
                                    <h5 class="card-title mb-4">Validator to a specific field</h5>

                                    <form id="pristine-valid-specificfield" novalidate method="post">
                                        <div class="form-group mb-3">
                                            <label class="form-label">required, first letter capitalized</label>
                                            <input type="text" class="form-control" required id="specificfield" />
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary">Submit form</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- container-fluid -->
        </div>
        <!-- End Page-content -->


        <?= $this->include('partials/footer') ?>
    </div>
    <!-- end main content-->

</div>
<!-- END layout-wrapper -->


<?= $this->include('partials/right-sidebar') ?>

<!-- JAVASCRIPT -->
<?= $this->include('partials/vendor-scripts') ?>

<!-- pristine js -->
<script src="assets/libs/pristinejs/pristine.min.js"></script>
<!-- form validation -->
<script src="assets/js/pages/form-validation.init.js"></script>

<script src="assets/js/app.js"></script>

</body>

</html>